/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class HiFiTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent c2) {
        return new HiFiTabbedPaneUI();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        Color[] SEP_COLORS = new Color[]{ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.brighter(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 60.0)};
        return SEP_COLORS;
    }

    protected void paintText(Graphics g2, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource)) {
            super.paintText(g2, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g2.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g2;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g2, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            Graphics2D g2D = (Graphics2D)g2;
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            Color fc = this.tabPane.getForegroundAt(tabIndex);
            if (isSelected) {
                fc = AbstractLookAndFeel.getTheme().getTabSelectionForegroundColor();
            }
            if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(tabIndex)) {
                fc = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
            }
            if (ColorHelper.getGrayValue(fc) > 128) {
                g2D.setColor(Color.black);
            } else {
                g2D.setColor(Color.white);
            }
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
            g2D.setComposite(composite);
            g2D.setColor(fc);
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        }
    }
}

